using System;
using Server;
using Server.Mobiles;
using Server.Gumps;

namespace Server.Items
{
	public class Chromite : Item
	{
		public override double DefaultWeight
		{
			get { return 1.0; }
		}
      
      [Constructable]
		public Chromite() : base( Utility.RandomMinMax( 4964, 4973 ) )
		{
			Stackable = true;
			Name = "chromite";
			Weight = 1.0;
			Light = LightType.Circle300;
			Movable = false;
			Hue = 2644;//Utility.RandomMinMax( 2589, 2611 );
		}

		public Chromite( Serial serial ) : base( serial )
		{
		}

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
		
		public override void OnDoubleClick( Mobile from )
		{
			base.OnDoubleClick( from );
			
			if ( this.ItemID == 6585 )
			   return;
			
         if ( ( from.InRange( this, 2 ) && from.InLOS( this ) ) || this.Parent != null )
			{
				if ( from is PlayerMobile )
				{
      			if (from.HasGump( typeof( ConfirmUseItem ) ) )
      				from.CloseGump(typeof( ConfirmUseItem ) );
      			from.SendGump( new ConfirmUseItem( this ) );
				}
			}
			else
			   from.SendMessage( "Jsi prilis daleko" );
		}
		
		private class ConfirmUseItem : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
			
			private Chromite m_Item;
			
			public ConfirmUseItem( Chromite item ) : base()
			{
				m_Item = item;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted || m_Item.ItemID == 6584 )
				  return;
				  
				if ( from.Guild != null )
				{
    				Guilds.Guild.GiveXp( from, Utility.RandomMinMax( 20, 50 ) );
				}

             m_Item.Stackable = true;
             m_Item.Movable = true;
             m_Item.ItemID = 6585;
             from.AddToBackpack( m_Item );
			}
		}
	}
}
